<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    @php($site=getSiteInfoForPdf())

    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>


    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .main-div {
            background-image: url({{asset("/img/site/idcard/".Session::get('ALIAS1')."-emp.png")}});
            background-position: center;
            background-size: cover;
            background-repeat: no-repeat;

            width: 326px;
            padding: 6px 2px;
            height: 199px;
            margin: 0 0 0 0;
            border-radius: 5px;
            float: left;
            overflow: hidden;
            border: 1px solid black;
        }

        .signature-div {
            float: right;
        }

        .st-image {
            width: 57px;
            height: 55px;
            border-radius: 10px;
            border: 1px solid black;
        }

        .data-table th {
            font-size: 10px;
            text-align: left;
            line-height: 80%;

        }

        .data-table td {
            font-size: 10px;
            text-align: left;
            line-height: 113%;
        }

        .page-break {
            page-break-after: always;
        }

        .site-logo {
            background: transparent;
            height: 40px;
            text-align: center;
            width: 45px;
        }

    </style>

</head>
<body>

{{--
@include('default.site.layout.pdf-header')


--}}


@foreach($card_data as $key => $value)

    {{--
        <div class="bg-image"
             style="width:199px; padding: 2px 6px; height:326px; margin:0 10px 10px 20px; border-radius: 5px;float: left; overflow: hidden">
    --}}

    <div class="main-div">

        <table cellspacing="0" border="0" width="100%;">

            <tbody>
            <tr>
                <td style="width: 100%;text-align: center">
                    <span style="font-size: 12px; text-transform:capitalize;font-weight: bold">{{$value['site_name'] ?? '--'}}</span>
                </td>
            </tr>
            <tr>
                <td style="width: 100%;text-align: center">
                    <img class="site-logo"
                         src="{!! asset($value['site_logo']) !!}">
                </td>
            </tr>

            </tbody>
        </table>

        <table class="data-table" cellspacing="0" border="0" width="100%;">

            <tbody>

            <tr>
                <td rowspan="7" style="width: 25%;">

                    <img class="st-image"
                         src="{{asset($value['latest_photo_path'])}}">

                    <b style=""> {{$value['employee_id']}}</b>


                </td>
                <th style="width: 10%; ">Name</th>
                <td style="width: 65%; ">
                    <p style="text-transform:uppercase;font-size: 9px; font-weight: bold; color: #0b2c89;">
                        : {{$value['full_name'] ?? '--'}} </p>
                </td>
            </tr>

            @if($value['designation_name'])

                <tr>
                    <th>
                        Designation dfsdfsadfsdfdsfsdfsdf
                    </th>
                    <td>
                        <nobr>: {{$value['designation_name'] ?? '--'}}</nobr>
                    </td>
                </tr>

            @endif

            @if($value['blood_group_name'])
                <tr>
                    <th>
                        B. Group
                    </th>
                    <td>
                        <nobr>: {{$value['blood_group_name'] ?? '--'}}</nobr>
                    </td>
                </tr>
            @endif
            @if($value['date_of_birth'])
                <tr>
                    <th>
                        DOB
                    </th>
                    <td>
                        : {{ date('d M Y', strtotime($value['date_of_birth'] ?? '1970-12-16'))}}
                    </td>
                </tr>
            @endif


            <tr>
                <th>
                    Mobile
                </th>
                <td>
                    <nobr>: {{$value['contact_number'] ?? '--'}}</nobr>
                </td>
            </tr>
            <tr>
                <th>
                    Email
                </th>
                <td>
                    <nobr>: {{$value['email'] ?? '--'}}</nobr>
                </td>
            </tr>


            <tr>
                <td colspan="2">
                    <div class="signature-div">
                        @if($signature)
                            <img style="text-align: center;" width="70" src="{{asset($signature)}}">
                        @endif
                        <br>
                        <span style="text-align: center;width: 100% ;border-top: 1px dotted black;">{{$designation}}</span>
                    </div>
                </td>
            </tr>

            </tbody>
        </table>


    </div>


    @if(($key+1) % 2== 0)
        <div style="clear:both;"></div>
    @endif


    @if(($key+1) % 10 == 0 )
        <div class="page-break"></div>
    @endif


@endforeach


</body>


<style>

    @page {
        size: a4;
        margin: 0;

    }

    body {
        margin: 10px 35px 3px;
        background-color: #ffffff;
    }


</style>

</html>












